###################################################
### chunk number 1: setup1
###################################################
library("cellHTS")


###################################################
### chunk number 2: setup2
###################################################
## for debugging:
options(error=recover)


###################################################
### chunk number 3: dataPath
###################################################
experimentName = "TwoWayAssay"
dataPath=system.file(experimentName, package="cellHTS") 


###################################################
### chunk number 4: source import function
###################################################
source(file.path(dataPath, "importData.R"))


###################################################
### chunk number 5: readPlateData
###################################################
x <- readPlateData("Platelist.txt", 
  importFun=importData, name=experimentName, path=dataPath)


###################################################
### chunk number 6: showX
###################################################
x


###################################################
### chunk number 7: plateFileTable
###################################################
cellHTS:::tableOutput(file.path(dataPath, "Platelist.txt"), selRows=1, 
  "plate list", preName="twoWay")


###################################################
### chunk number 8: configure the data
###################################################
x <- configure(x, confFile="Plateconf.txt", 
     descripFile = "Description.txt", path=dataPath)


###################################################
### chunk number 9: well annottaion
###################################################
table(x$wellAnno)


###################################################
### chunk number 10: annotate the data
###################################################
x <- annotate(x, geneIDFile="GeneIDs.txt", path=dataPath)


###################################################
### chunk number 11: plateConfscreenLogTable
###################################################
cellHTS:::tableOutput(file.path(dataPath, "Plateconf.txt"), 
    "plate configuration", selRows=1:4, preName="twoWay")


###################################################
### chunk number 12: geneIDsTable
###################################################
cellHTS:::tableOutput(file.path(dataPath, "GeneIDs.txt"), "gene ID", 
  selRows = 3:6, preName="twoWay")


###################################################
### chunk number 13: define controls
###################################################
negCtr <- "(?i)^GFP$|^mock$"
posCtr <- list(act = "(?i)^AATK$|^ATTK$", inh = "(?i)^MAP2K6$")


###################################################
### chunk number 14: writeReport1Show eval=FALSE
###################################################
## out <- writeReport(x, outdir="2Wraw",
##      posControls=posCtr, negControls=negCtr, 
##      plotPlateArgs=list(xrange=c(300, 4000)))


###################################################
### chunk number 15: writeReport1Do
###################################################
out <- writeReport(x, force=TRUE, outdir="2Wraw", 
   posControls=posCtr, negControls=negCtr, 
   plotPlateArgs=list(xrange=c(300, 4000)))


###################################################
### chunk number 16: browseReport1 eval=FALSE
###################################################
## browseURL(out)


###################################################
### chunk number 17: normalization
###################################################
x <- normalizePlates(x, normalizationMethod ="negatives", 
   negControls = negCtr, transform=log2)


###################################################
### chunk number 18: summarizeReplicates
###################################################
x <- summarizeReplicates(x, zscore="+", summary="mean") 


###################################################
### chunk number 19: boxplotzscore
###################################################
ylim <- quantile(x$score, c(0.001, 0.999), na.rm=TRUE)
boxplot(x$score ~ x$wellAnno, col="lightblue", main="scores", outline=FALSE, ylim=ylim, xaxt="n")
lab <- unique(x$plateConf$Content)
lab <- lab[match(levels(x$wellAnno), tolower(lab))]
axis(1, at=c(1:nlevels(x$wellAnno)), labels=lab)


###################################################
### chunk number 20: report2Show eval=FALSE
###################################################
## out <- writeReport(x, outdir="2Wnormalized", posControls=posCtr, negControls=negCtr, 
##    plotPlateArgs=list(xrange=c(-1,1)), imageScreenArgs=list(zrange=c(-2,3)))


###################################################
### chunk number 21: report2Do
###################################################
out <- writeReport(x, outdir="2Wnormalized", posControls=posCtr, negControls=negCtr, 
   plotPlateArgs=list(xrange=c(-1,1)), imageScreenArgs=list(zrange=c(-2,3)), force=TRUE)


###################################################
### chunk number 22: browse2 eval=FALSE
###################################################
## browseURL(out)


###################################################
### chunk number 23: savex
###################################################
save(x, file=paste(experimentName, ".rda", sep=""))


###################################################
### chunk number 24: sessionInfo
###################################################
toLatex(sessionInfo())


