### Name: summarizeReplicates
### Title: Summarize between scored replicate values given in a cellHTS
###   object to obtain a single value for each probe
### Aliases: summarizeReplicates
### Keywords: manip

### ** Examples

    data(KcViabSmall)
    # normalize
    x <- normalizePlates(KcViabSmall, scale="multiplicative", method="median", varianceAdjust="none")
    # score the replicates
    x <- scoreReplicates(x, sign="-", method="zscore")
    # summarize the replicates (conservative approach: take the minimum value between replicates)
    x <- summarizeReplicates(x, summary="min")



