### Name: getDynamicRange
### Title: Per-plate dynamic range of a cellHTS object
### Aliases: getDynamicRange
### Keywords: manip

### ** Examples

    data(KcViabSmall)
    ## pCtrls <- c("pos") 
    ## nCtrls <- c("neg") 
    ## or for safety reasons (not a problem for the current well annotation, however) 
    pCtrls <- c("^pos$") 
    nCtrls <- c("^neg$")
    dr <- getDynamicRange(KcViabSmall, definition="ratio", posControls=pCtrls, negControls=nCtrls)
    ## same as: 
    ## getDynamicRange(KcViabSmall)
    
    x <- normalizePlates(KcViabSmall, scale="multiplicative", log=TRUE, method="median", varianceAdjust="none")
    try(drn <- getDynamicRange(x, definition="ratio"))
    drn <- getDynamicRange(x, definition="difference")



