###################################################
### chunk number 1: options
###################################################
if (Sys.info()["sysname"] == "Darwin")
  options(bitmapType = "cairo")


###################################################
### chunk number 2: loadlibs
###################################################
library("Biobase")
library("CCl4")
data("CCl4")


###################################################
### chunk number 3: vsn-NChannelSet
###################################################
library("vsn")
nCCl4 = justvsn(CCl4, subsample=2000)


###################################################
### chunk number 4: XYcoordinates
###################################################
featureData(nCCl4)$X = featureData(nCCl4)$Row
featureData(nCCl4)$Y = featureData(nCCl4)$Column


###################################################
### chunk number 5: hasTarget
###################################################
featureData(nCCl4)$hasTarget = (regexpr("^NM", featureData(nCCl4)$Name) > 0)


###################################################
### chunk number 6: Covariate
###################################################
datapath = system.file("extdata", package="CCl4")
p = read.AnnotatedDataFrame("samplesInfo.txt", path=datapath)
cond = paste(p$RIN.Cy3,p$RIN.Cy5,sep="/")
poor = grep(cond,pattern="2.5")
medium = grep(cond,pattern="^5/|/5")
good = grep(cond,pattern="9.7")
cov = rep(0, length = nrow(p))
cov[good] = "Good"
cov[medium] = "Medium"
cov[poor] = "Poor"
phenoData(nCCl4)$RNAintegrity = cov


###################################################
### chunk number 7: arrayQM2col
###################################################
library("arrayQualityMetrics")
arrayQualityMetrics(expressionset = nCCl4,
                    outdir = "CCl4",
                    force = TRUE,
                    do.logtransform = FALSE,
                    split.plots = FALSE,
                    intgroup = "RNAintegrity")


###################################################
### chunk number 8: pkgs
###################################################
toLatex(sessionInfo())


