###################################################
### chunk number 1: setup
###################################################
options(width=69)


###################################################
### chunk number 2: packages
###################################################
library(VanillaICE)


###################################################
### chunk number 3: data
###################################################
data(chromosome1)
annotation(chromosome1)
chromosome1


###################################################
### chunk number 4: plotSnp
###################################################
gp <- plotSnp(chromosome1)
show(gp)


###################################################
### chunk number 5: options
###################################################
options <- new("HmmOptions",
	       states=c("D", "N", "L", "A"),
	       snpset=chromosome1,
	       copyNumber.location=c(1, 2, 2, 3),
	       probHomCall=c(0.99, 0.7, 0.99, 0.7))
validObject(options)


###################################################
### chunk number 6: HmmParameters
###################################################
params <- new("HmmParameter", 
	      states=states(options),
	      initialStateProbability=0.99)
cn.emission <- copyNumber.emission(options)
gt.emission <- calls.emission(options)
emission(params) <- cn.emission + gt.emission ##log scale


###################################################
### chunk number 7: genomicDistance
###################################################
genomicDistance(params) <- exp(-2 * physicalDistance(options)/(100*1e6))
transitionScale(params) <- scaleTransitionProbability(options)
class(params)


###################################################
### chunk number 8: fit eval=FALSE
###################################################
## fit <- hmm(options, params)


###################################################
### chunk number 9: load
###################################################
data(fit)


###################################################
### chunk number 10: 
###################################################
fit
breakpoints(fit)


###################################################
### chunk number 11: summary
###################################################
summary(fit)


###################################################
### chunk number 12: vanillaPlot
###################################################
gp <- plotSnp(snpset(options), fit)
gp$abline.v <- TRUE ##plots vertical dashed lines
show(gp)


###################################################
### chunk number 13: params
###################################################
options <- new("HmmOptions", 
	       snpset=chromosome1, 
	       states=c("D", "N", "L", "A"), 
	       copyNumber.location=c(1, 2, 2, 3),
	       copyNumber.ICE=TRUE,
	       probHomCall=c(0.99, 0.75, 0.99, 0.75))
cn.emission <- copyNumber.emission(options)
emission(params) <- cn.emission + gt.emission
fit.ice <- hmm(options, params)


###################################################
### chunk number 14: params2 eval=FALSE
###################################################
## options <- new("HmmOptions", 
## 	       snpset=chromosome1, 
## 	       states=c("D", "N", "L", "A"), 
## 	       copyNumber.location=c(1, 2, 2, 3),
## 	       copyNumber.ICE=TRUE, 
## 	       calls.ICE=TRUE,
## 	       probHomCall=c(0.99, 0.75))
## params <- new("HmmParameter", 
## 	      states=states(options),
## 	      initialStateProbability=0.99)
## cn.emission <- copyNumber.emission(options)
## genomicDistance(params) <- exp(-2 * physicalDistance(options)/(100*1e6))
## transitionScale(params) <- scaleTransitionProbability(options)
## gt.emit <- calls.emission(options)
## gt.emission <- array(NA, dim(cn.emission))
## gt.emission[, , 1:2] <- gt.emit
## gt.emission[, , 3:4] <- gt.emit
## emission(params) <- cn.emission + gt.emission
## fit.ice <- hmm(options, params)


###################################################
### chunk number 15: icePlot
###################################################
gp <- plotSnp(snpset(options), fit.ice)
gp$abline.v <- TRUE
gp$col.predict <- c("darkblue", "white", "yellow", "orange")
show(gp)
legend(-0.05, 10, fill=gp$col.predict[c(1, 3, 4)],
       legend=c("< 2 copies", "copy-neutral LOH", "> 2 copies"),
       bty="n", title="predicted states")
legend(0, 0.8, legend="predictions", bty="n", cex=0.8, adj=0)


###################################################
### chunk number 16: hmmParameters eval=FALSE
###################################################
## new("HmmParameter")


###################################################
### chunk number 17: 
###################################################
params[5, 1, ]


###################################################
### chunk number 18: tau.scale
###################################################
transitionScale(params)


###################################################
### chunk number 19: 
###################################################
transitionScale(params) <- scaleTransitionProbability(params, SCALE=10)
transitionScale(params)


###################################################
### chunk number 20: hmmOutput
###################################################
fit


###################################################
### chunk number 21: breaks
###################################################
breaks <- breakpoints(fit)
breaks <- breaks[breaks[, "state"] != "N", ]


###################################################
### chunk number 22: orderBreaks
###################################################
breaks[order(breaks[, "chr"], breaks[, "size"], decreasing=TRUE), ]


###################################################
### chunk number 23: summary
###################################################
summary(fit)


###################################################
### chunk number 24: copyNumberHmm
###################################################
chr1.cn <- as(chromosome1, "SnpCopyNumberSet")
options <- new("HmmOptions",
	       snpset=chr1.cn,
	       states=c("D", "N", "A"),
	       copyNumber.location=1:3)
params.cn <- new("HmmParameter",  
		 states=c("D", "N", "A"))
emission(params.cn) <- copyNumber.emission(options)
transitionScale(params.cn) <- scaleTransitionProbability(options)
genomicDistance(params.cn) <- exp(-2*physicalDistance(options)/(100*1e6))
fit.cn <- hmm(options, params.cn)
breakpoints(fit.cn)
graph.par <- plotSnp(snpset(options), fit.cn)
graph.par$abline.v <- FALSE


###################################################
### chunk number 25: copyNumberFigure
###################################################
print(graph.par)
legend(0, 0.8, fill=graph.par$col.predict[c(1, 3)], 
       legend=c("< 2 copes", "> 2 copies"),
       bty="n", cex=0.8)


###################################################
### chunk number 26: 
###################################################
rm(chr1.cn, fit.cn, params.cn)


###################################################
### chunk number 27: chr1Calls
###################################################
chr1.calls <- as(chromosome1, "SnpCallSet")
options <- new("HmmOptions",
	       snpset=chr1.calls,
	       states=c("L", "N"),
	       probHomCall=c(0.99, 0.7))
params.calls <- new("HmmParameter", 
		    states=states(options))
transitionScale(params.calls) <- scaleTransitionProbability(options)
genomicDistance(params.calls) <- exp(-2*physicalDistance(options)/(100*1e6))
emission(params.calls) <- calls.emission(options)

fit.calls <- hmm(options, params.calls)
breakpoints(fit.calls)
gp <- plotSnp(snpset(options), fit.calls)
gp$col.predict <- c("black", "white")
gp$ylim <- c(-0.5, 1)
gp$add.centromere <- FALSE
gp$abline.v <- TRUE
gp$cytoband.ycoords <- c(-0.45, -0.4)
gp$hmm.ycoords <- c(-0.2, -0.05)


###################################################
### chunk number 28: callsFigure
###################################################
show(gp)
legend(0, -0.1, legend="LOH", fill="black", 
       title="predictions", bty="o", cex=0.8)


###################################################
### chunk number 29: 
###################################################
toLatex(sessionInfo())


