### Name: RtreemixData-class
### Title: Class "RtreemixData"
### Aliases: RtreemixData-class Description Events Patients Sample
###   eventsNum sampleSize Description<- Events<- Patients<-
###   Description,RtreemixData-method Description<-,RtreemixData-method
###   Events,RtreemixData-method Events<-,RtreemixData-method
###   Patients,RtreemixData-method Patients<-,RtreemixData-method
###   Sample,RtreemixData-method eventsNum,RtreemixData-method
###   sampleSize,RtreemixData-method initialize,RtreemixData-method
###   print,RtreemixData-method show,RtreemixData-method
### Keywords: classes

### ** Examples

## Create an RtreemixData object from a file given in the examples directory of the package.
data1 <- new("RtreemixData", File = paste(system.file(package = "Rtreemix"), "/examples/treemix.pat", sep = ""))
show(data1) ## show the RtreemixData object

## Create an RtreemixData object from a randomly generated RtreemixModel object.
rand.mod <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
data2 <- sim(model = rand.mod, no.draws = 300)
show(data2)

## Create an RtreemixData object from a given binary matrix.
bin.mat <- cbind(c(1, 0, 0, 1, 1), c(0, 1, 0, 0, 1), c(1, 1, 0, 1, 0))
data3 <- new("RtreemixData", Sample = bin.mat, Events = c("0", "1", "2",
"3"))
show(data3)



