### Name: preprocess
### Title: Preprocess Nimblegen Raw Intensities
### Aliases: preprocess
### Keywords: manip

### ** Examples

   exDir <- system.file("exData",package="Ringo")
   exRG <- readNimblegen("example_targets.txt","spottypes.txt",path=exDir)
   exampleX <- preprocess(exRG)
   sampleNames(exampleX) <- 
     make.names(paste(exRG$targets$Cy5,"vs",exRG$targets$Cy3,sep="_"))
   print(exampleX)

   ### compare VSN to NimbleGen's tukey-biweight scaling
   exampleX.NG <- preprocess(exRG, method="nimblegen")
   sampleNames(exampleX.NG) <- sampleNames(exampleX)
   if (interactive())
     corPlot(cbind(exprs(exampleX),exprs(exampleX.NG)),
       grouping=c("VSN normalized","Tukey-biweight scaled"))



