### Name: clusterData-methods
### Title: Get and set attributes for a cluster of an Ragraph object
### Aliases: clusterData-methods clusterData<--methods clusterData
###   clusterData<-
### Keywords: methods

### ** Examples


library(graph)
library(Rgraphviz)

g1_gz <- gzfile(system.file("GXL/graphExample-01.gxl.gz",package="graph"), open="rb")
g11_gz <- gzfile(system.file("GXL/graphExample-11.gxl.gz",package="graph"), open="rb")
g1 <- fromGXL(g1_gz)
g11 <- fromGXL(g11_gz)
g1_11 <- join(g1, g11)
sgl <- vector(mode="list", length=2)
sgl[[1]] <- list(graph=g1, cluster=TRUE)
sgl[[2]] <- list(graph=g11, cluster=TRUE)
ng <- agopenSimple(g1_11, "tmpsg", subGList=sgl)
clusterData(ng, 1, c("bgcolor")) <- c("blue")
clusterData(ng, 2, c("bgcolor")) <- c("red")
toFile(ng, layoutType="dot", filename="g1_11_dot.ps", fileType="ps")




