###################################################
### chunk number 1: 
###################################################
library(MLInterfaces)
library(golubEsets)


###################################################
### chunk number 2: redu
###################################################
data(Golub_Merge)
smallG <- Golub_Merge[200:259,]
smallG


###################################################
### chunk number 3: doknnB
###################################################
#krun <- knnB( smallG, "ALL.AML", trainInd=1:40 )
krun = MLearn(ALL.AML~., smallG, knnI(k=1), 1:40)
krun


###################################################
### chunk number 4: lkco
###################################################
confuMat(krun)


###################################################
### chunk number 5: lkco2
###################################################
set.seed(1234)
#nns <- nnetB( smallG[1:10,], "ALL.AML", trainInd=1:40, size=2, decay=.01, maxit=250 )
nns <- MLearn( ALL.AML~., smallG[1:10,], nnetI, trainInd=1:40, size=2, decay=.01, maxit=250 )
nns
confuMat(nns)


###################################################
### chunk number 6: 
###################################################
summary(RObject(nns))


###################################################
### chunk number 7: 
###################################################
ags <- agnesB(smallG, k=4, height=0, stand=FALSE)


###################################################
### chunk number 8: 
###################################################
plot(RObject(ags), which.plot=2)


###################################################
### chunk number 9: lkci
###################################################
getClass("learnerSchema")
getClass("xvalSpec")


###################################################
### chunk number 10: lkcc
###################################################
getClass("classifierOutput")


###################################################
### chunk number 11: lkcl
###################################################
getClass("clustOutput")


###################################################
### chunk number 12: dox
###################################################
library(golubEsets)
data(Golub_Merge)
smallG <- Golub_Merge[200:250,]
lk1 <- MLearn(ALL.AML~., smallG, knnI(k=1,l=0), xvalSpec("LOO"))
confuMat(lk1)


###################################################
### chunk number 13: doxr
###################################################
ranpart = function(K, data) {
 N = nrow(data)
 cu = as.numeric(cut(1:N, K))
 sample(cu, size=N, replace=FALSE)
}
ranPartition = function(K) function(data, clab, iternum) {
 p = ranpart(K, data)
 which(p == iternum)
}
lkran <- MLearn(ALL.AML~., smallG, knnI(k=1,l=0), xvalSpec("LOG", 8, partitionFunc=ranPartition(8)))
confuMat(lkran)


###################################################
### chunk number 14: dox2
###################################################
lk3 <- MLearn(ALL.AML~., smallG, knnI(k=1,l=0), xvalSpec("LOG", 8, partitionFunc=balKfold.xvspec(8)))
confuMat(lk3)


###################################################
### chunk number 15: dofs
###################################################
#
# use Stephen Henderson's feature selection extensions
#
t.fun<-function(data, fac)
{
        require(genefilter)
        # deal with the integer storage of golubTrain@exprs!
        xd <- matrix(as.double(exprs(data)), nrow=nrow(exprs(data)))
        return(abs(rowttests(xd,pData(data)[[fac]], tstatOnly=FALSE)$statistic))
}
lk3f <- xval(smallG, "ALL.AML", knnB, xvalMethod="LOO", 0:0, fsFun=t.fun)
table(lk3f$out, smallG$ALL.AML)



###################################################
### chunk number 16: getpp
###################################################
predProb <- round(testScores(nns),3)


###################################################
### chunk number 17: gettrue
###################################################
truth <- as.character(smallG$ALL.AML[-c(1:40)]) 
simpPred <- as.character(testPredictions(nns))


###################################################
### chunk number 18: mkclo
###################################################
douClo <- function(pprob)  function(lo,hi) pprob>lo & pprob<hi


###################################################
### chunk number 19: evclo
###################################################
smallDou <- douClo(predProb)


###################################################
### chunk number 20: repla
###################################################
douPred <- simpPred
douPred[smallDou(.48,.52)] <- "doubt"


###################################################
### chunk number 21: lkpr
###################################################
mm <- cbind(predProb,truth,simpPred,douPred)
mm
table(mm[,"truth"], mm[,"simpPred"])
table(mm[,"truth"], mm[,"douPred"])


