### Name: GeneSet-class
### Title: Class "GeneSet"
### Aliases: GeneSet-class [,GeneSet,character,ANY-method
###   [,GeneSet,numeric,ANY-method [,ExpressionSet,GeneSet,ANY-method
###   [[,GeneSet,character-method [[,GeneSet,numeric-method
###   Logic,character,GeneSet-method |,GeneSet,GeneSet-method
###   |,GeneSet,character-method $,GeneSet-method &,GeneSet,GeneSet-method
###   &,GeneSet,character-method
###   collectionType<-,GeneSet,CollectionType-method
###   collectionType,GeneSet-method contributor<-,GeneSet,character-method
###   contributor,GeneSet-method creationDate<-,GeneSet,character-method
###   creationDate,GeneSet-method description<-,GeneSet,character-method
###   description,GeneSet-method geneIds<-,GeneSet,character-method
###   geneIds,GeneSet-method initialize,GeneSet-method
###   intersect,GeneSet,GeneSet-method
###   longDescription<-,GeneSet,character-method
###   longDescription,GeneSet-method organism<-,GeneSet,character-method
###   organism,GeneSet-method pubMedIds<-,GeneSet,character-method
###   pubMedIds,GeneSet-method setdiff,GeneSet,GeneSet-method
###   setIdentifier<-,GeneSet,character-method setIdentifier,GeneSet-method
###   setName<-,GeneSet,character-method setName,GeneSet-method
###   geneIdType<-,GeneSet,character-method
###   geneIdType<-,GeneSet,GeneIdentifierType-method
###   geneIdType,GeneSet-method setVersion<-,GeneSet,Versions-method
###   setVersion,GeneSet-method show,GeneSet-method
###   union,GeneSet,GeneSet-method urls<-,GeneSet,character-method
###   urls,GeneSet-method collectionType<- collectionType contributor<-
###   contributor creationDate<- creationDate geneIds<- geneIds geneIdType
###   geneIdType<- longDescription<- longDescription organism<- organism
###   setIdentifier<- setIdentifier setName<- setName setVersion<-
###   setVersion urls<- urls
### Keywords: classes

### ** Examples

## Empty gene set
GeneSet()
## Gene set from ExpressionSet
data(sample.ExpressionSet)
gs1 <- GeneSet(sample.ExpressionSet[100:109])
## GeneSet from Broad XML; 'fl' could be a url
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
gs2 <- getBroadSets(fl)[[1]] # actually, a list of two gene sets
## GeneSet from list of geneIds
geneIds <- geneIds(gs2) # any character vector would do
gs3 <- GeneSet(geneIds=geneIds)
## unspecified set type, so...
is(geneIdType(gs3), "NullIdentifier") == TRUE
## update set type to match encoding of identifiers
geneIdType(gs2)
geneIdType(gs3) <- SymbolIdentifier()

## Convert between set types; this consults the 'annotation'
## information encoded in the 'AnnotationIdentifier' set type and the
## corresponding annotation package.
## Not run: 
##D gs4 <- gs1
##D geneIdType(gs4) <- EntrezIdentifier()
## End(Not run)

## logical (set) operations
gs5 <- GeneSet(sample.ExpressionSet[100:109], setName="subset1")
gs6 <- GeneSet(sample.ExpressionSet[105:114], setName="subset2")
## intersection: 5 'genes'; note the set name '(subset1 & subset2)'
gs5 & gs6
## union: 15 'genes'; note the set name
gs5 | gs6
## an identity
gs7 <- gs5 | gs6
gs8 <- setdiff(gs5, gs6) | (gs5 & gs6) | setdiff(gs6, gs5)
identical(geneIds(gs7), geneIds(gs8))
identical(gs7, gs8) == FALSE # gs7 and gs8 setNames differ

## output
tmp <- tempfile()
toBroadXML(gs2, tmp)
noquote(readLines(tmp))
## must be BroadCollection() collectionType 
try(toBroadXML(gs1))
gs9 <- gs1
collectionType(gs9) <- BroadCollection()
toBroadXML(gs9, tmp)
unlink(tmp)
toBroadXML(gs9) # no connection --> character vector
## list of geneIds --> vector of Broad GENESET XML
gs10 <- getBroadSets(fl) # two sets
entries <- sapply(gs10, function(x) toBroadXML(x)[[2]])

## list mapIdentifiers available for GeneSet
showMethods("mapIdentifiers", classes="GeneSet", inherit=FALSE)



