### Name: GeneSet
### Title: Methods to construct GeneSet instances
### Aliases: GeneSet GeneSet-methods GeneSet,missing-method
###   GeneSet,character-method GeneSet,GeneIdentifierType-method
###   GeneSet,ExpressionSet-method GeneSet,BroadCollection-method
###   GeneSet,GOCollection-method
### Keywords: methods

### ** Examples

## Empty gene set
GeneSet()

## Gene set from ExpressionSet
data(sample.ExpressionSet)
gs1 <- GeneSet(sample.ExpressionSet[100:109])

## GeneSet from Broad XML; 'fl' could be a url
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
gs2 <- getBroadSets(fl)[[1]] # actually, a list of two gene sets

## GeneSet from list of gene identifiers
geneIds <- geneIds(gs2) # any character vector would do
gs3 <- GeneSet(geneIds)
## unspecified set type, so...
is(geneIdType(gs3), "NullIdentifier") == TRUE
## update set type to match encoding of identifiers
geneIdType(gs2)
geneIdType(gs3) <- EntrezIdentifier()
## other ways of accomplishing the same
gs4 <- GeneSet(geneIds, geneIdType=EntrezIdentifier())
gs5 <- GeneSet(EntrezIdentifier(), geneIds=geneIds)



