### Name: snpScreen
### Title: compute model fits over a sequence of SNPs
### Aliases: snpScreenResult-class twSnpScreenResult-class
###   show,snpScreenResult-method show,twSnpScreenResult-method
###   annotation,snpScreenResult-method
###   snpScreen,racExSet,snpMeta,genesym,formula,function,numeric-method
###   snpScreen,racExSet,snpMeta,genesym,formula,function,missing-method
###   snpScreen,racExSet,snpMeta,genesym,formula,GGfitter-method
###   twSnpScreen,racExSet,snpMeta,formula,GGfitter-method twSnpScreen
###   snpScreen extract_p plot_mlp
### Keywords: models

### ** Examples

example(make_racExSet)
dem
dem = exclMono(dem)
snpNames(dem)[1:4]
featureNames(dem)[1:4]
data(chr20GGdem)
data(chr20meta)
data(geneLocs_hsa)
scr1 = snpScreen(dem, chr20meta, genesym("DDR1"), ~., lm,  gran=100 )
scr1[[1]]
scr2 = snpScreen(dem, chr20meta, genesym("DDR1"), ~factor(.), lm,  gran=200 )
scr2[[1]]
plot_mlp(scr1, chr20meta, geneLocDF=geneLocs_hsa)
chr20GGdem = exclMono(chr20GGdem)
ut = unix.time(scr2 <- snpScreen(chr20GGdem, chr20meta, genesym("CPNE1"), ~., fastAGMfitter))
ut
scr2
names(scr2)
plot_mlp(scr2, chr20meta, geneLocDF=geneLocs_hsa)
#
# here we work on a WebQTL computation
#
# get the expr+genotype data
data(gse2031GG)
# get a provisional snp metadata structure
data(INB34snpMeta)
# run a screen for Erdr1
ss = snpScreen(gse2031GG, INB34snpMeta, genesym("Erdr1"), ~., fastAGMfitter)
plot_mlp(ss, INB34snpMeta, gchr="all", plotf=plot, organism="mouse" )
#
# following will throw warnings, so dontrun but paste by hand
#
## Not run: 
##D  someg = c("DDR1", "RFC2", "HSPA6", "PAX8", "GUCA1A")
##D  somesnps = c("rs6088779", "rs6120881", "rs7346331", "rs6088780", "rs2425024", 
##D  "rs6088781", "rs6141540", "rs11167262", "rs6119594", "rs1555322", 
##D  "rs2425027", "rs6142341", "rs6058215", "rs6060331", "rs6088785", 
##D  "rs6087694", "rs12106107", "rs2425032", "rs2425037", "rs2275274")
##D  
##D  somesnps = somesnps[c(5L, 8L, 10L, 11L, 14L, 18L, 19L, 20L)]
##D  trim = chr20GGdem[ genesym(someg[1:3]), ]
##D  trim = trim[ snpID(somesnps), ]
##D  lktw = twSnpScreen( trim, chr20meta, ~., fastAGMfitter)
##D  lktw
##D # topSnps(lktw, 5)
## End(Not run)




