### Name: segments.summary
### Title: Additional summary measured for the segments
### Aliases: segments.summary
### Keywords: nonparametric

### ** Examples


# test code on an easy data set
set.seed(25)
genomdat1 <- rnorm(500, sd=0.1) +
rep(c(-0.2,0.1,1,-0.5,0.2,-0.5,0.1,-0.2),c(137,87,17,49,29,52,87,42))
genomdat2 <- rnorm(500, sd=0.1) +
rep(c(-0.2,0.1,1,-0.5,0.2,-0.5,0.1,-0.2),c(137,87,17,49,29,52,87,42))
genomdat1[sample(1:500,5)] <- NA
chrom <- rep(1:2,c(290,210))
maploc <- c(1:290,1:210)
test1 <- segment(CNA(cbind(genomdat1,genomdat2), chrom, maploc))
segments.summary(test1)




