comp.t                 package:DEDS                 R Documentation

_C_o_m_p_u_t_i_n_g _O_n_e _a_n_d _T_w_o _S_a_m_p_l_e _t-_s_t_a_t_i_s_t_i_c _f_o_r _D_i_f_f_e_r_e_n_t_i_a_l _E_x_p_r_e_s_s_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     'comp.t' returns a function of one argument with bindings for 'L',
     'mu', 'var.equal'. This function accepts a microarray data matrix
     as its single argment, when evaluated, computes t statistics for
     each row of the matrix.

_U_s_a_g_e:

     comp.t(L = NULL, mu = 0, var.equal = FALSE)

_A_r_g_u_m_e_n_t_s:

       L: A vector of integers corresponding to observation (column)
          class labels. For k classes, the labels must be integers
          between 0 and k-1. 

      mu: A number indicating the true value of the mean (or difference
          in means if you are performing a two sample test). 

var.equal: a logical variable indicating whether to treat the two
          variances as being equal. If 'TRUE' then the pooled variance
          is used to estimate the variance otherwise the Welch
          statistic will be calculated. 

_D_e_t_a_i_l_s:

     The function returned by 'comp.t' calculates t statistics for each
     row of the microarary data matrix, given specific class labels.

_V_a_l_u_e:

     'comp.t' returns a function with bindings for 'L', 'mu',
     'var.equal', which calculates and returns of vector of t
     statistics for each row in the data matrix.

_A_u_t_h_o_r(_s):

     Yuanyuan Xiao, yxiao@itsa.ucsf.edu, 
      Jean Yee Hwa Yang, jean@biostat.ucsf.edu.

_S_e_e _A_l_s_o:

     'comp.FC', 'comp.F'

_E_x_a_m_p_l_e_s:

     X <- matrix(rnorm(1000,0,0.5), nc=10)
     L <- rep(0:1,c(5,5))

     # genes 1-10 are differentially expressed
     X[1:10,6:10]<-X[1:10,6:10]+1

     # two sample test, unequal variance
     t.fun <- comp.t(L)
     t.X <- t.fun(X)

     # two sample test, equal variance
     t.fun <- comp.t(L, var.equal=TRUE)
     t.X <- t.fun(X)

