### Name: CGHcall
### Title: Calling aberrations for array CGH tumor profiles.
### Aliases: CGHcall
### Keywords: misc

### ** Examples

  data(Wilting)
  ## Convert to this-is-escaped-codenormal-bracket53bracket-normal object
  cgh <- make_cghRaw(Wilting)
  print(cgh)
  ## First preprocess the data
  raw.data <- preprocess(cgh)
  ## Simple global median normalization for samples with 75% tumor cells
  perc.tumor <- rep(0.75, 3)
  normalized.data <- normalize(raw.data, cellularity=perc.tumor)  
  ## Segmentation with slightly relaxed significance level to accept change-points.
  ## Note that segmentation can take a long time.
  ## Not run: segmented.data <- segmentData(normalized.data, alpha=0.02)
  ## Call aberrations
  ## Not run: result <- CGHcall(segmented.data)



