###################################################
### chunk number 1: gety
###################################################
library(Biostrings)
file <- system.file("extdata", "someORF.fa", package="Biostrings")
orf <- read.DNAStringSet(file, "fasta")
orf


###################################################
### chunk number 2: lkblo
###################################################
data(BLOSUM50)
BLOSUM50[1:4,1:4]


###################################################
### chunk number 3: haubold
###################################################
s1 <- 
  DNAString("ACTTCACCAGCTCCCTGGCGGTAAGTTGATCAAAGGAAACGCAAAGTTTTCAAG")
s2 <-
  DNAString("GTTTCACTACTTCCTTTCGGGTAAGTAAATATATAAATATATAAAAATATAATTTTCATC")

mat <- matrix(-3, nrow = 4, ncol = 4)
diag(mat) <- 1
rownames(mat) <- colnames(mat) <- DNA_ALPHABET[1:4]
globalAlign <- pairwiseAlignment(s1, s2, substitutionMatrix = mat,
  gapOpening = -5, gapExtension = -2)
localAlign <- pairwiseAlignment(s1, s2, type = "local", substitutionMatrix = mat,
  gapOpening = -5, gapExtension = -2)
overlapAlign <- pairwiseAlignment(s1, s2, type = "overlap",
  substitutionMatrix = mat, gapOpening = -5, gapExtension = -2)


###################################################
### chunk number 4: runnw
###################################################
nwdemo <- 
  pairwiseAlignment(AAString("PAWHEAE"), AAString("HEAGAWGHEE"), substitutionMatrix = BLOSUM50,
                    gapOpening = 0, gapExtension = -8)
nwdemo


###################################################
### chunk number 5: lksc
###################################################
score(nwdemo)


###################################################
### chunk number 6: doal
###################################################
orf10 <- DNAStringSet(orf, end=10)
consmat(orf10)


###################################################
### chunk number 7: infco
###################################################
infContent <- function(Lmers) {
 zlog <- function(x) ifelse(x==0,0,log(x))
 co <- consmat(Lmers, freq=TRUE)
 lets <- rownames(co)
 fr <- alphabetFrequency(Lmers)[lets]
 sum(co*zlog(co/fr))
}
infContent(orf10)


