### Name: findPalindromes
### Title: Searching a sequence for palindromes or complemented palindromes
### Aliases: findPalindromes findPalindromes,XString-method
###   findPalindromes,XStringViews-method
###   findPalindromes,MaskedXString-method palindromeArmLength
###   palindromeArmLength,XString-method
###   palindromeArmLength,XStringViews-method palindromeLeftArm
###   palindromeLeftArm,XString-method
###   palindromeLeftArm,XStringViews-method palindromeRightArm
###   palindromeRightArm,XString-method
###   palindromeRightArm,XStringViews-method findComplementedPalindromes
###   findComplementedPalindromes,DNAString-method
###   findComplementedPalindromes,XStringViews-method
###   findComplementedPalindromes,MaskedXString-method
###   complementedPalindromeArmLength
###   complementedPalindromeArmLength,DNAString-method
###   complementedPalindromeArmLength,XStringViews-method
###   complementedPalindromeLeftArm
###   complementedPalindromeLeftArm,DNAString-method
###   complementedPalindromeLeftArm,XStringViews-method
###   complementedPalindromeRightArm
###   complementedPalindromeRightArm,DNAString-method
###   complementedPalindromeRightArm,XStringViews-method
### Keywords: methods

### ** Examples

  ## Note that complemented palindromes (like palindromes) can be nested
  findComplementedPalindromes(DNAString("ACGTTNAACGT-ACGTTNAACGT"))

  ## A real use case
  library(BSgenome.Dmelanogaster.UCSC.dm3)
  chrX <- maskMotif(Dmelanogaster$chrX, "N")
  chrX_pals <- findComplementedPalindromes(chrX, min.armlength=50, max.looplength=20)
  complementedPalindromeArmLength(chrX_pals) # 251

  ## Of course, whitespaces matter
  palindromeArmLength(BString("was it a car or a cat I saw"))

  ## Note that the 2 arms of a strict palindrome (or strict complemented
  ## palindrome) are equal to the full sequence.
  palindromeLeftArm(BString("Delia saw I was aileD"))
  complementedPalindromeLeftArm(DNAString("N-ACGTT-AACGT-N"))
  palindromeLeftArm(DNAString("N-AAA-N-N-TTT-N"))



