### Name: align-utils
### Title: Utility functions related to sequence alignment
### Aliases: consmat consmat,character-method consmat,matrix-method
###   consmat,list-method consmat,XStringSet-method
###   consmat,XStringViews-method consmat,XStringAlign-method
### Keywords: methods

### ** Examples

  file <- system.file("extdata", "someORF.fa", package="Biostrings")
  orf <- read.DNAStringSet(file, "fasta")

  ## To illustrate, the following example assumes the ORF data
  ## to be aligned for the first 10 positions (patently false):
  orf10 <- DNAStringSet(orf, end=10)
  consmat(orf10)

  ## For the character matrix containing the "exploded" representation
  ## of the views, do:
  as.matrix(orf10, mode="character")



