### Name: XStringViews-constructors
### Title: Basic functions for creating or modifying XStringViews objects
### Aliases: XStringViews-constructors views adjacentViews XStringViews
###   XStringViews,ANY-method XStringViews,file-method
###   XStringViews,XString-method XStringViews,XStringViews-method
###   restrict,XStringViews-method trim narrow,XStringViews-method subviews
###   gaps,XStringViews-method BStringViews BStringViews,ANY-method
###   BStringViews,file-method BStringViews,XString-method
###   BStringViews,XStringViews-method
### Keywords: methods

### ** Examples

  ## 'start' and 'end' are recycled
  views("abcdefghij", 2:1, 4)
  views("abcdefghij", 5:7, )
  views("abcdefghij", , 5:7)

  ## Views can be "out of limits"
  views("abcdefghij", 2:0, 4)

  ## Views on a DNAString object
  v12 <- views(DNAString("TAATAATG"), -2:9, 0:11)

  ## Creating adjacent views
  v3 <- adjacentViews("abcdefghij", 4:2, gapwidth=1)

  XStringViews(v12, subjectClass="RNAString")
  XStringViews(AAString("MARKSLEMSIR*"))
  XStringViews("abcdefghij", subjectClass="BString")

  ## Applying gaps() to an XStringViews object
  v2 <- views("abCDefgHIJK", start=c(8, 3), end=c(14, 4))
  gaps(v2)



