### Name: XStringSet-io
### Title: Read/write an XStringSet or XStringViews object from/to a file
### Aliases: read.XStringViews read.BStringSet read.DNAStringSet
###   read.RNAStringSet read.AAStringSet write.XStringSet
###   write.XStringViews FASTArecordsToCharacter CharacterToFASTArecords
###   FASTArecordsToXStringViews XStringSetToFASTArecords read.BStringViews
###   write.BStringViews FASTArecordsToBStringViews
### Keywords: manip

### ** Examples

  file <- system.file("extdata", "someORF.fa", package="Biostrings")
  x <- read.DNAStringSet(file, "fasta")
  x
  write.XStringSet(x, format="fasta") # writes to the console

  ## Converting 'x'...
  ## ... to a list of FASTA records (as one returned by the "readFASTA" function)
  x1 <- XStringSetToFASTArecords(x)
  ## ... to a named character vector
  x2 <- FASTArecordsToCharacter(x1) # same as 'as.character(x)'



