### Name: MaskCollection-class
### Title: MaskCollection objects
### Aliases: class:MaskCollection MaskCollection-class MaskCollection
###   nir_list nir_list,MaskCollection-method length,MaskCollection-method
###   width,MaskCollection-method active active,MaskCollection-method
###   active<- active<-,MaskCollection-method names,MaskCollection-method
###   names<-,MaskCollection-method Mask isEmpty,MaskCollection-method
###   max,MaskCollection-method min,MaskCollection-method maskedwidth
###   maskedwidth,MaskCollection-method maskedratio
###   maskedratio,MaskCollection-method [[,MaskCollection-method
###   [[<-,MaskCollection-method [,MaskCollection-method
###   [<-,MaskCollection-method append,MaskCollection-method
###   narrow,MaskCollection-method reduce,MaskCollection-method
###   gaps,MaskCollection-method coerce,MaskCollection,NormalIRanges-method
###   show,MaskCollection-method
### Keywords: methods classes

### ** Examples

  ## Making a MaskCollection object:
  mask1 <- Mask(mask.width=29, start=c(11, 25, 28), width=c(5, 2, 2))
  mask2 <- Mask(mask.width=29, start=c(3, 10, 27), width=c(5, 8, 1))
  mask3 <- Mask(mask.width=29, start=c(7, 12), width=c(2, 4))
  mymasks <- append(append(mask1, mask2), mask3)
  mymasks
  length(mymasks)
  width(mymasks)
  reduce(mymasks)
  gaps(mymasks)

  ## Putting a MaskCollection object on a sequence:
  x <- DNAString("ACACAACTAGATAGNACTNNGAGAGACGC")
  x
  length(x)  # same as width(mymasks)
  nchar(x)   # same as length(x)
  masks(x) <- mymasks
  x
  length(x)  # has not changed
  nchar(x)   # has changed
  alphabetFrequency(x)

  ## Removing the masks:
  masks(x) <- NULL
  x
  alphabetFrequency(x)

  ## Active/inactive masks:
  reduce(mymasks)
  active(mymasks)[2] <- FALSE
  mymasks
  reduce(mymasks)

  ## Other advanced operations:
  mymasks[[2]]
  length(mymasks[[2]])
  mymasks[[2]][-3]
  append(mymasks[-2], gaps(mymasks[2]))
  mymasks2 <- narrow(mymasks, start=8)
  mymasks2
  mymasks2[[2]]



