### Name: BGmix-package
### Title: BGmix fits a variety of Bayesian hierarchical models for finding
###   differential gene expression between 2 or more experimental
###   conditions.
### Aliases: BGmix-package
### Keywords: models

### ** Examples

## Note this is a very short MCMC run!
## For good analysis need proper burn-in period.
data(ybar,ss)
outdir <- BGmix(ybar, ss, c(8,8), nburn=0, niter=100, nthin=1,trace.pred=1)

## Basic plot of parameters
params <- ccParams(outdir)
plotBasic(params,ybar,ss)

## plots of FDR and related quantities
fdr <- calcFDR(params)
par(mfrow=c(1,2))
plotFDR(fdr)

## plots of Bayesian p-values
## for predictive checks of mixture prior 
pred <- ccPred(outdir,q.trace=TRUE)
plotPredChecks(pred$pval.ybar.mix2,params$pc,probz=0.5)

## plots of predictive density superimposed on data
plotMixDensity(params,pred,ybar,ss)



