### Name: CallRegions
### Title: Call and merge regions using joint posterior probabilities
###   calculated by BAC.
### Aliases: CallRegions
### Keywords: models

### ** Examples

# Load the data
data(ER)
# Only select the first 5000 probes for speed-up
ER<-ER[1:5000,]
# Calculate the joint posterior probabilities
#Only use 100 iterations for speed up (You should use more! See default value) 
BAConER<-BAC(ER[,5:7], ER[,2:4], B=100,verbose=FALSE,w=5)
# For Regions using 0.5 cut-off for the joint posterior probabilities
ERregions<-CallRegions(ER[,1],BAConER$jointPP,cutoff=0.5,maxGap=500)
# Create the BED file
nRegions<-max(ERregions)
BED<-matrix(0,nRegions,4)
for(i in 1:nRegions)
{
BED[i,2:3]<-range(ER[ERregions==i,1])
#The score should be between 0 and 1000
BED[i,4]<-max(BAConER$jointPP[ERregions==i])*1000
}
BED<-data.frame(BED)
# The ER data is a subset of chr 21
BED[,1]<-"chr21"
names(BED)<-c("chrom","chromStart","chromEnd","Score")
# print it
print(BED)



