### Name: error.correction
### Title: Estimate sequencing errors and compute corrected counts
### Aliases: estimate.errors.mean compute.sequence.neighbors
###   em.estimate.error.given
### Keywords: error

### ** Examples

library(sagenhaft)
B6Hypo <-read.sage.library(system.file("data/B6HypothalHFI.sage",
                           package="sagenhaft")) 
E15post <- read.sage.library(system.file("data/E15postHFI.sage",
                             package="sagenhaft")) 
testlib <- combine.libs(B6Hypo, E15post)
testlib <- estimate.errors.mean(testlib)
testlib <- em.estimate.error.given(testlib)
tagneighbors <- compute.sequence.neighbors(testlib$seqs[,"seq"], 10,
                          testlib$seqs[,paste("q", 1:10, sep="")]) 



