### Name: matchprobes
### Title: A function to match a query sequence to the sequences of a set
###   of probes.
### Aliases: matchprobes
### Keywords: manip

### ** Examples

  ## The main intention for this function is together with the probe
  ## tables from the "probe" data packages, e.g.:
  ## > library(hgu95av2probe)
  ## > data(probe)
  ## > seq <- probe$sequence
  ##
  ## Since we do not want to be dependent on the presence of this 
  ## data package, for the sake of example we simply simulate some
  ## probe sequences:

  bases <- c("A", "C", "G", "T")
  trsk  <- sapply(1:10, function(x) paste(bases[ceiling(4*runif(1280))], collapse=""))

  seq <- sample(trsk, 20, replace=TRUE)
  starts <- ceiling((nchar(seq)-26)*runif(length(seq)))

  seq <- substr(seq, starts, starts+24)
  seq <- c(seq, complementSeq(seq, start=13, stop=13))

  matchprobes(trsk, seq, probepos=TRUE)



