### Name: maImage
### Title: Color image for cDNA microarray spot statistics
### Aliases: maImage
### Keywords: hplot

### ** Examples


# To see the demo type demo(marrayPlots)

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Microarray color palettes
Gcol <- maPalette(low = "white", high = "green", k = 50)
Rcol <- maPalette(low = "white", high = "red", k = 50)
RGcol <- maPalette(low = "green", high = "red", k = 50)

# Color images of green and red background and foreground intensities
maImage(swirl[, 3], x="maGb")
maImage(swirl[, 3], x = "maGf", subset = TRUE, col = Gcol, contours = FALSE, bar = TRUE, main="Swirl array 93")
maImage(swirl[, 3], x = "maRb", contour=TRUE)
maImage(swirl[, 3], x = "maRf", bar=FALSE)

# Color images of pre-normalization intensity log-ratios
maImage(swirl[, 1])
maImage(swirl[, 3], x = "maM", subset = maTop(maM(swirl[, 3]), h = 0.1, l = 0.1), col = RGcol, contours = FALSE, bar = TRUE, main = "Swirl array 93: image of pre-normalization M for % 10 tails")

# Color image of print-tip-group
maImage(swirl[, 1],x="maPrintTip")




