### Name: image
### Title: Method image for objects defined in this package
### Aliases: image.maigesRaw image.maiges image.maigesANOVA
###   image.maigesRelNetB image.maigesRelNetM image.maigesActMod
###   image.maigesActNet image
### Keywords: array

### ** Examples

## Loading the dataset
data(gastro)

## Doing image plots (using package marray), default method showing the
## W values (for 1st chip), after showing the A values (2nd chip) and
## red background (20th chip). As we are using as small piece of a large
## dataset, this command gives some inconvenient warnings...
## Not run: 
##D image(gastro.raw[,1])
##D image(gastro.raw[,2], "maA")
##D image(gastro.raw[,20], "maRb")
##D 
##D ## Example for normalized objects (showing A values for the 5th chip).
##D image(gastro.norm[,5], "maA")
## End(Not run)


## Example for object of class maigesRelNetB

## Constructing the relevance network (Butte's method) for sample
## 'Tissue' equal to 'Neso' for the 1st gene group
gastro.net = relNetworkB(gastro.summ, sLabelID="Tissue", 
  samples="Neso", geneGrp=1, type="Rpearson")

image(gastro.net)



## Example for object of class maigesRelNetM

## Constructing the relevance network for sample
## 'Tissue' comparing 'Neso' and 'Aeso' for the 1st gene group
gastro.net = relNetworkM(gastro.summ, sLabelID="Tissue", 
  samples = list(Neso="Neso", Aeso="Aeso"), geneGrp=11,
  type="Rpearson")

image(gastro.net)



