### Name: boxplot
### Title: Method boxplot for objects defined in this package
### Aliases: boxplot.maigesRaw boxplot.maiges boxplot.maigesANOVA
###   boxplot.maigesDEcluster boxplot
### Keywords: array

### ** Examples

## Loading the dataset
data(gastro)

## To see the boxplots for W values in all chips
boxplot(gastro.raw)  ## maigesRaw class
boxplot(gastro.norm) ## maigesNorm class
boxplot(gastro.summ) ## summarized data (also maigesNorm class)

## To see the boxplots for W values in individual chips
## separating into print tips. But, as we used only a fraction (500
## spots) of the total dataset, this examples doesn't work.
## Not run: 
##D boxplot(gastro.raw[,1])  ## maigesRaw class
##D boxplot(gastro.norm[,8]) ## maigesNorm class
##D boxplot(gastro.summ[,19]) ## summarized data (also maigesNorm class)
## End(Not run)

## Boxplot for individual genes into ANOVA model fitting
gastro.ANOVA = designANOVA(gastro.summ, factors="Tissue")
gastro.ANOVAfit = deGenesANOVA(gastro.ANOVA, retF=TRUE)

boxplot(gastro.ANOVAfit, name="KLK13", gLabelID="GeneName", 
sLabelID="Tissue")



