/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.systemsbiology.gaggle.experiment.metadata.Condition;
import org.systemsbiology.gaggle.experiment.metadata.DataSetDescription;
import org.systemsbiology.gaggle.experiment.metadata.Variable;

public class MetaData
implements Serializable {
    String title;
    String date;
    String uri;
    HashMap predicates;
    HashMap links;
    ArrayList dataSetDescriptions;
    ArrayList conditions;
    HashMap variableSummary;
    HashMap selectionCriteria;

    public MetaData(String string, String string2) {
        this.title = string;
        this.date = string2;
        this.uri = null;
        this.predicates = new HashMap();
        this.links = new HashMap();
        this.dataSetDescriptions = new ArrayList();
        this.conditions = new ArrayList();
        this.variableSummary = new HashMap();
        this.selectionCriteria = new HashMap();
    }

    public MetaData(String string) {
        this(string, null);
    }

    public String[] getReferenceUrls() {
        return new String[]{"http://www.sewardpark.net"};
    }

    public String getTitle() {
        return this.title;
    }

    public String getDate() {
        return this.date;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getUri() {
        return this.uri;
    }

    public String getSpecies() {
        String[] stringArray = this.getPredicateNamesSorted();
        String string = this.getPredicate("species");
        if (string == null) {
            return "unknown";
        }
        return string;
    }

    public void setPredicates(HashMap hashMap) {
        this.predicates = hashMap;
    }

    public HashMap getPredicates() {
        return this.predicates;
    }

    public String[] getPredicateNamesSorted() {
        Object[] objectArray = this.predicates.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String getPredicate(String string) {
        if (this.predicates.containsKey(string)) {
            return (String)this.predicates.get(string);
        }
        return null;
    }

    public void setDataSetDescriptions(ArrayList arrayList) {
        this.dataSetDescriptions = arrayList;
    }

    public String getUriBase() {
        int n = this.uri.lastIndexOf(File.separator);
        if (n > 0) {
            return this.uri.substring(0, n);
        }
        return "";
    }

    private DataSetDescription[] absolutizeDataSetUris(DataSetDescription[] dataSetDescriptionArray) {
        if (this.uri == null || this.uri.length() == 0) {
            return dataSetDescriptionArray;
        }
        for (int i = 0; i < dataSetDescriptionArray.length; ++i) {
            String string = dataSetDescriptionArray[i].getUri().trim();
            boolean bl = string.indexOf("://") > 0;
            char c = string.charAt(0);
            if (bl || !Character.isLetterOrDigit(c)) continue;
            String string2 = this.getUriBase() + "/" + string;
            dataSetDescriptionArray[i].setUri(string2);
        }
        return dataSetDescriptionArray;
    }

    public DataSetDescription[] getRawDataSetDescriptions() {
        return this.dataSetDescriptions.toArray(new DataSetDescription[0]);
    }

    public DataSetDescription[] getDataSetDescriptions() {
        return this.absolutizeDataSetUris(this.getRawDataSetDescriptions());
    }

    public HashMap getVariableSummary() {
        return this.variableSummary;
    }

    public void addLink(String string, String string2) {
        this.links.put(string, string2);
    }

    public HashMap getReferenceLinks() {
        return this.links;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
        this.updateVariableSummary(condition);
    }

    protected void updateVariableSummary(Condition condition) {
        String[] stringArray = condition.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Variable variable = condition.getVariable(stringArray[i]);
            String string = variable.getName();
            String string2 = variable.getValue();
            String string3 = variable.getUnits();
            HashMap hashMap = !this.variableSummary.containsKey(string) ? new HashMap() : (HashMap)this.variableSummary.get(string);
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, string3);
            }
            this.variableSummary.put(string, hashMap);
        }
    }

    public Condition[] getConditions() {
        return this.conditions.toArray(new Condition[0]);
    }

    public boolean hasCondition(String string) {
        Condition[] conditionArray = this.getConditions();
        for (int i = 0; i < conditionArray.length; ++i) {
            if (!conditionArray[i].getAlias().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public Condition getCondition(String string) {
        Condition[] conditionArray = this.getConditions();
        for (int i = 0; i < conditionArray.length; ++i) {
            if (!conditionArray[i].getAlias().equalsIgnoreCase(string)) continue;
            return conditionArray[i];
        }
        return null;
    }

    public String[] getVariableNames() {
        return this.variableSummary.keySet().toArray(new String[0]);
    }

    public HashMap getVariableValuesWithUnits(String string) {
        if (!this.variableSummary.containsKey(string)) {
            return null;
        }
        return (HashMap)this.variableSummary.get(string);
    }

    public String getUnits(String string, String string2) {
        if (!this.variableSummary.containsKey(string)) {
            return null;
        }
        HashMap hashMap = (HashMap)this.variableSummary.get(string);
        if (!hashMap.containsKey(string2)) {
            return null;
        }
        return (String)hashMap.get(string2);
    }

    public String[] getSortedVariableValues(String string) {
        if (!this.variableSummary.containsKey(string)) {
            return new String[0];
        }
        HashMap hashMap = this.getVariableValuesWithUnits(string);
        if (hashMap == null) {
            return new String[0];
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String[] getNamesOfSelectedVariables() {
        Object[] objectArray = this.selectionCriteria.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public boolean columnSelected(Condition condition, HashMap hashMap) {
        boolean bl = true;
        String[] stringArray = this.getNamesOfSelectedVariables();
        Variable[] variableArray = condition.getVariables();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < variableArray.length; ++i) {
            ArrayList arrayList;
            Variable variable = variableArray[i];
            String string = variable.getName();
            String string2 = variable.getValue();
            if (!hashMap.containsKey(string) || (arrayList = (ArrayList)hashMap.get(string)).size() == 0) continue;
            if (arrayList.contains(string2)) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        return bl2 && !bl3;
    }

    public Condition[] getSelectedConditions() {
        if (this.selectionCriteria.size() == 0) {
            return new Condition[0];
        }
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (int i = 0; i < this.conditions.size(); ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (!this.columnSelected(condition, this.selectionCriteria)) continue;
            arrayList.add(condition);
        }
        return arrayList.toArray(new Condition[0]);
    }

    public String[] getSelectedConditionsAsAliases() {
        Condition[] conditionArray = this.getSelectedConditions();
        Object[] objectArray = new String[conditionArray.length];
        for (int i = 0; i < conditionArray.length; ++i) {
            objectArray[i] = conditionArray[i].getAlias();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void clearSelectionCriteria() {
        this.selectionCriteria = new HashMap();
    }

    public HashMap getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public void selectConditionByName(String string) {
        HashMap hashMap = this.getVariableValuesWithUnits(string);
        if (hashMap == null) {
            return;
        }
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addSelectionCriterion(string, stringArray[i]);
        }
    }

    public void selectAllConditions() {
        String[] stringArray = this.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            HashMap hashMap = this.getVariableValuesWithUnits(stringArray[i]);
            if (hashMap == null) continue;
            String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
            for (int j = 0; j < stringArray2.length; ++j) {
                this.addSelectionCriterion(stringArray[i], stringArray2[j]);
            }
        }
    }

    public void addSelectionCriterion(String string, String string2) {
        if (!this.variableSummary.containsKey(string)) {
            return;
        }
        HashMap hashMap = (HashMap)this.variableSummary.get(string);
        if (!((HashMap)this.variableSummary.get(string)).containsKey(string2)) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        if (this.selectionCriteria.containsKey(string)) {
            arrayList = (ArrayList)this.selectionCriteria.get(string);
        }
        arrayList.add(string2);
        this.selectionCriteria.put(string, arrayList);
    }

    public void setConditions(ArrayList arrayList) {
        this.conditions = arrayList;
    }

    public String[] getConditionAliases() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Condition[] conditionArray = this.getConditions();
        for (int i = 0; i < conditionArray.length; ++i) {
            arrayList.add(conditionArray[i].getAlias());
        }
        return arrayList.toArray(new String[0]);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("title: ");
        stringBuffer.append(this.title);
        stringBuffer.append("\n");
        stringBuffer.append("datasets: ");
        DataSetDescription[] dataSetDescriptionArray = this.getDataSetDescriptions();
        for (int i = 0; i < dataSetDescriptionArray.length; ++i) {
            stringBuffer.append(dataSetDescriptionArray[i].toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("predicates: ");
        String[] stringArray = this.predicates.keySet().toArray(new String[0]);
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("variableDefinitions: ");
        stringBuffer.append(this.getVariableSummary());
        stringBuffer.append("\n");
        stringBuffer.append("conditions: ");
        for (n = 0; n < this.conditions.size(); ++n) {
            stringBuffer.append(this.getConditions()[n].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

