### Name: xyplot
### Title: Method implementing Lattice ECDF plots for flow data
### Aliases: xyplot splom panel.xyplot.flowset prepanel.xyplot.flowset
###   xyplot,formula,flowSet-method xyplot,flowFrame,missing-method
###   xyplot,formula,flowFrame-method splom,flowFrame,missing-method
### Keywords: methods dplot

### ** Examples


data(GvHD)

## simple bivariate scatter plot (a.k.a. dot plot)
## by default ('smooth=TRUE') panel.smoothScatter is used

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit, data = GvHD, 
       layout = c(7, 5))

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       layout = c(7, 5))

## version without smooth

xyplot(`SSC-H` ~ `FSC-H` | Visit + Patient, data = GvHD, 
       smooth = FALSE, strip = strip.custom(strip.names = TRUE))

## several examples with time on the X axis

xyplot(`FSC-H` ~ Time | Visit, GvHD, 
       smooth = FALSE, type = "l", 
       subset = (Patient == 5))

xyplot(`FSC-H` ~ Time | Patient:Visit, GvHD, 
       smooth = FALSE, type = "l",
       strip = FALSE, strip.left = TRUE,
       aspect = "xy")

## combine plots for two channels

ssc.time <- 

    xyplot(`SSC-H` ~ Time | factor(Patient):factor(Visit), GvHD, 
           smooth = FALSE, type = "l",
           strip = FALSE,
           strip.left = strip.custom(horizontal = TRUE),
           par.strip.text = list(lines = 3),
           between = list(y = rep(c(0, 0.5), c(6, 1))),
           scales = list(x = list(axs = "i"), y = list(draw = FALSE)),
           layout = c(1, 35))

fsc.time <- 

    xyplot(`FSC-H` ~ Time | factor(Patient):factor(Visit), GvHD, 
           smooth = FALSE, type = "l",
           strip = FALSE,
           strip.left = strip.custom(horizontal = TRUE),
           par.strip.text = list(lines = 3),
           between = list(y = rep(c(0, 0.5), c(6, 1))),
           scales = list(x = list(axs = "i"), y = list(draw = FALSE)),
           layout = c(1, 35))

plot(fsc.time, split = c(1, 1, 2, 1))
plot(ssc.time, split = c(2, 1, 2, 1), newpage = FALSE)

## saving plots as variables allows more manipulation

plot(update(fsc.time[29:35], layout = c(1, 7)),
     split = c(1, 1, 1, 2))

plot(update(ssc.time[29:35], layout = c(1, 7)),
     split = c(1, 2, 1, 2), newpage = FALSE)

## scatter plot matrix of individual flowFrames

splom(GvHD[["s10a07"]], smooth = FALSE)

splom(GvHD[["s10a07"]], smooth = FALSE,
      prepanel.limits = function(x) quantile(as.numeric(x), c(0.0, 0.99)))

## time plot of individual flowFrames

xyplot(GvHD[["s5a07"]], time = "Time")

xyplot(`FSC-H` + `SSC-H` + `FL1-H` ~ Time, GvHD[["s5a07"]],
       aspect = "xy", outer = TRUE,
       scales = list(y = "free"),
       type = "l", smooth = FALSE)

xyplot(`FSC-H` ~ `SSC-H`, GvHD[["s5a01"]], nbin = 100)

## displaying filters

n2gate <- norm2Filter("SSC-H", "FSC-H")

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit, data = GvHD,
       filter = n2gate, ## displayFilter = TRUE,
       layout = c(7, 5))

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       smooth = FALSE,
       filter = n2gate, ## displayFilter = list(border = "black"),
       layout = c(7, 5))

xyplot(`SSC-H` ~ `FSC-H` | Patient:Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       subset = Patient == "6",
       filter = rectangleGate("FSC-H"=c(5.5, 7),"SSC-H"=c(4, 6.5)),
       displayFilter = list(lwd = 3))

n2gate.results <- filter(GvHD, n2gate %on% transform("SSC-H"=asinh,"FSC-H"=asinh))

xyplot(`SSC-H` ~ `FSC-H` | Visit, data = GvHD,
       subset = Patient == "6",
       filterResults = n2gate.results, smooth = FALSE)

xyplot(`SSC-H` ~ `FSC-H` | Visit,
       data = GvHD,
       subset = Patient == "6",
       smooth = FALSE,
       filter = n2gate,
       filterResults = n2gate.results,
       displayFilter = list(lwd = 0.5))

xyplot(`SSC-H` ~ `FSC-H` | Visit,
       data = transform("SSC-H"=asinh,"FSC-H"=asinh) %on% GvHD,
       subset = Patient == "6",
       smooth = FALSE,
       filter = rectangleGate("FSC-H"=c(5.5, 7),"SSC-H"=c(4, 6.5)),
       filterResults = n2gate.results,
       displayFilter = list(border = 'red'))




