### Name: processArrayData
### Title: Automated processing of two colour DNA microarray data
### Aliases: processArrayData
### Keywords: utilities

### ** Examples


       LOADPATH <- file.path(.path.package("arrayMagic"), "extdata")
       SAVEPATH <- tempdir()
        SLIDEDESCRIPTIONFILE <- "slideDescription"
  
        resultList <- processArrayData(
                             loadPath=LOADPATH, 
                              savePath=SAVEPATH,
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE
                  )
       writeToFile(arrayDataObject=resultList$arrayDataObject,
                   exprSetRGObject=resultList$exprSetRGObject,
                   fileName="normalisedData.txt",
                   savePath=SAVEPATH)

       summarizedResult <- slideMerge(exprSetRGObject=resultList$exprSetRGObject, slideMergeColumn="replicates" )

        qPL <- qualityParameters(arrayDataObject=resultList$arrayDataObject,
                                 exprSetRGObject=resultList$exprSetRGObject)

        visualiseQualityParameters(qualityParameters=qPL$qualityParameters,
                                   savePath=tempdir())

        qualityDiagnostics(
                    arrayDataObject=resultList$arrayDataObject,
                    exprSetRGObject=resultList$exprSetRGObject,
                    qualityParametersList=qPL,
                    groupingColumn="replicates",
                    slideNameColumn="fileName",
                    savePath=tempdir(),
                    plotOutput="pdf")

        unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))
         resultListG <- processArrayData(
                             loadPath=LOADPATH, 
                              savePath=SAVEPATH,
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                             plotOutput="pdf",
                             hybridisationGroups = list((1:4),(5:9))
                  )
 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))
 resultListG2 <- processArrayData(
                             loadPath=LOADPATH, 
                              savePath=SAVEPATH,
                             slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                             plotOutput="pdf",
                             objectsFileName = "exprSetRG.RData",
                             hybridisationGroups = "slideBySlide"
                                         )
 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))

 SLIDEDESCRIPTIONFILE <- "genericChannelsPerFile"
 spotAnnoColumns <- c("Index", "Label" , "Type" , "Name" , "ID" )
 dataColumns <- c("Normalized....","Average....","Normalized....","Average....")
 names(dataColumns) <- c("greenForeground","greenBackground",
                      "redForeground","redBackground")

 resultGenericChannel <- processArrayData(
                                spotIdentifier="Index",
                                loadPath=LOADPATH, 
                                savePath=SAVEPATH,
                                slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                                normalisationMethod="none",
                                channelColumn="channel",
                                fileNameColumn="files",
                                slideNameColumn="name",
                                type="genericOneFilePerChannel",
                                spotAnnoColumns=spotAnnoColumns,
                                dataColumns=dataColumns
                            )

 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))
 SLIDEDESCRIPTIONFILE <- "genericChannelsPerFileTwo"
 dataColumns <- c("Integral..QL.","Bkg..QL.", "Integral..QL.","Bkg..QL.")
 names(dataColumns) <- c("greenForeground","greenBackground",
                      "redForeground","redBackground")

 resultGenericChannelTwo <- processArrayData(
                                spotIdentifier="ID",
                                loadPath=LOADPATH, 
                                savePath=SAVEPATH,
                                slideDescriptionFile=SLIDEDESCRIPTIONFILE,
                                normalisationMethod="vsn",
                                channelColumn="channel",
                                fileNameColumn="files",
                                slideNameColumn="name",
                                subtractBackground=TRUE,
                                type="genericOneFilePerChannel",
                                spotAnnoColumns=spotAnnoColumns,
                                dataColumns=dataColumns
                            )
 unlink(file.path(SAVEPATH, paste(SLIDEDESCRIPTIONFILE,"_processed",sep="")))

  ## Don't show: 

    ## End Don't show     
 


