\name{selectLibs}
\alias{selectLibs}
\alias{getDBArgs}
\alias{getUnixDBArgs}
\alias{getBinding}
\alias{getWinDBArgs}
\alias{getTag}
\alias{getDefaults}
\alias{getSLyzerArgs}
\alias{writeSLyzerArgs}
\alias{modSLyzerArgs}
\alias{setSLyzerArgs}
\alias{runSLyzer}
\alias{writeSAGEKNN}
\alias{getSAGEKNN}
\alias{getLibCounts}
\alias{mapLib2File}
\alias{linkTag2UG}
\alias{remapTagNUG}
\alias{SAGEFromGEO}
\alias{procSAGE}
\alias{mapSAGE2UG}
\alias{SAGELyzerArgs}
\alias{showDBError}
\alias{setKNNArgs}
\alias{findNG4Tag}
\alias{ENV}
\title{Functions to support the widgets of SAGElyzer}
\description{
  SAGElyzer has several widgets that takes inputs from users before
  performing certain tasks. Functions described in this help
  documentation provides supports for the widgets. They may have limited
  reuse values for other purposes.
}
\usage{
selectLibs()
getDBArgs(what = c("map", "counts", "info"))
getUnixDBArgs(binding = "pg")
getBinding(binding = c("pg"))
getWinDBArgs(what = c("map", "counts", "info"))
getTag()
getDefaults()
getSLyzerArgs(argName = "SAGELyzerArgs")
writeSLyzerArgs(args,argName = "SAGELyzerArgs")
modSLyzerArgs(argName, value)
setSLyzerArgs()
runSLyzer()
writeSAGEKNN(knn, targetSAGE)
getSAGEKNN()
getLibCounts()
mapLib2File()
linkTag2UG()
remapTagNUG(mappings)
SAGEFromGEO()
procSAGE()
mapSAGE2UG()
showDBError()
setKNNArgs()
findNG4Tag()
}

\arguments{
  \item{what}{\code{what} - a character string that can be "map",
    "counts", or "info" to indicate the database table to be accessed}
  \item{binding}{\code{binding} - a character string for the name of the
    database binding object to be used. "pg" for PostgreSQL is the only
    one that is currently supported}
  \item{args}{\code{args} a list of arguments that will be stored in a
    predefined environment for later usr}
  \item{argName}{\code{argName} a character string for the name of an
    element in the stored list of arguments}
  \item{value}{\code{value} a value to be associated with an element of
    the stored list of arguments}
  \item{knn}{\code{knn} a named vector with the names being the tags
    that are closely related to a given target tag and values being the
    calculated distances}
  \item{targetSAGE}{\code{targetSAGE} a character string for the target
    tag selectd}
  \item{mappings}{\code{mappings} a matrix with mappings between SAGE
    tags and UniGene ids}
}

\details{
  \code{selectLibs} allows users to select a set of SAGE libraries from an
  interactive interface and store the data in an pre-defined environment
  for later use.

  \code{getDBArgs} invokes an interactive interface for users to input the
  arguments for making connections to an existing database. User inputs
  are stored in a predefined environment for later use. The function
  calls \code{\link{getUnixDBArgs}} or \code{\link{getWinDBArgs}}
  depending on the type of the operating system.

  \code{getUnixDBArgs} invokes the interface for getting arguments for
  making a connection to a database under Unix. 

  \code{getWinDBArgs} invokes an interactive interface for getting arguments
  for making a connection to a database under windows through an ODBC
  bridge.

  \code{getTag} invokes an interfactive interface for users to input the
  target SAGE tag base on which tags with similar expression pattern will be
  sought.

  \code{getDefaults} invokes an interactive interface for users to reset
  the default values  arguments for \code{\link{SAGELyzer}}.

  \code{getSLyzerArgs} returns the argument list stored in a predefined
  environment. 

  \code{writeSLyzerArgs} overwrites the argument list stored in a
  predefined environment.

  \code{modSLyzerArgs} modifies the value of a given element of the
  argument list that is stroed in a predefined environment.

  \code{setSLyzerArgs} initializes the values of the argument list and
  store teh list in a predefined environment for later use.

  \code{runSLyzer} invokes the function \code{\link{SAGELyzer}} with correct
  arguments to calculate the nearest neighbor for a given targe tag.
  
  \code{writeSAGEKNN} writes the calculated distances for tags that are
  closely related to the target tag to a predefined environment.

  \code{getSAGEKNN} gets the value for the nearest neighbor of a target
  tag that have been stored in a predefined environment.
  
  \code{getLibCounts} invokes the interface to show the actual counts of
  the nearest neighbors of a target tag.

  \code{mapLib2File} invokes the interface that displays the mapping
  between the column name of the database table for counts and the
  original file name that was used to populate the column.

  \code{linkTag2UG} invokes an HTML page with links of the tags that are
  closely related to the target tag to UniGene data page for each of the
  tags.

  \code{remapTagNUG} returns a matrix with each SAGE tag mapped to a
  single UniGene id from a matrix where a tag may be mapped to multiple
  UniGene ids separated by a ";"
  
  \code{SAGEFromGEO} invokes the interactive interface to get SAGE
  libraries from the NCBI web site.
  
  \code{procSAGE} process SAGE libraries and write the merged data to a
  database table.

  \code{mapSAGE2UG} invokes an interactive interface for taking inputs
  from users in order to map SAGE tags to UniGene ids and write the
  mappings to a database table.
}
\value{

  \code{getUnixDBArgs} returns a list containing
  \item{dbname}{\code{dbname} a character string for the name of the
    database} 
  \item{user}{\code{user} a character string for the name of the user}
  \item{password}{\code{password} a character string for a password}
  \item{host}{\code{host} a character string for the domain name or IP
    address of the host for the database}
  \item{counts}{\code{counts} a character string for the name of the
    databsae table storing SGAE count data}
  \item{info}{\code{info} a character string for the name of the
    database table storing mapping information and normalization data}
  \item{map}{\code{map} a character string for the name of the database
    table storing the mappings between tag and UniGene ids}

  \code{getWinDBArgs} returns a list containing
  \item{DSN}{\code{DSN} a character string for the name of data source
    name}
   \item{counts}{\code{counts} a character string for the name of the
    databsae table storing SGAE count data}
  \item{info}{\code{info} a character string for the name of the
    database table storing mapping information and normalization data}
  \item{map}{\code{map} a character string for the name of the database
    table storing the mappings between tag and UniGene ids}

  \code{getSLyzerArgs} returns a list of arguments that is stroed in a
  predefined environment.

  \code{getSAGEKNN} returns a named vector with tag names and their
  distances to a target tag.

  \code{remapTagNUG} returns a matrix with two columns.
}
\references{\url{http://www.ncbi.nlm.nih.gov/geo}}
\author{Jianhua Zhang}
 
\seealso{\code{\link{SAGELyzer}}, \code{\link{mergeSAGE}}}
\examples{
## No examples are provided as the functions may require the support of
## database or human interference
}
\keyword{misc}
