### Name: flags
### Title: Examples of flag objects to apply to CGH arrays
### Aliases: amplicon.flag chromosome.flag control.flag flags
###   global.spatial.flag local.spatial.flag spatial.flag position.flag
###   rep.flag replicate.flag SNR.flag ref.snr.flag dapi.snr.flag spot.flag
###   unique.flag val.mark.flag intensity.flag
### Keywords: datasets

### ** Examples

data(flags)

### complete normalization of an arrayCGH object (with spatial gradient):
## Initialize flag$args

flag.list1 <- list(local.spatial=local.spatial.flag,
  global.spatial=global.spatial.flag, spot=spot.flag, SNR=SNR.flag,
  val.mark=val.mark.flag, unique=unique.flag,
  amplicon=amplicon.flag, chromosome=chromosome.flag,
  replicate=replicate.flag)

data(spatial)
## Not run: 
##D gradient.norm <- norm.arrayCGH(gradient, flag.list=flag.list1,
##D var="LogRatio", FUN=median, na.rm=TRUE)
## End(Not run)
print(gradient.norm$flags) ## spot-level flag summary (computed by flag.summary)

### complete normalization of an arrayCGH object (with local spatial bias):
## Initialize flag$args

flag.list2 <- list(spatial=local.spatial.flag, spot=spot.corr.flag,
ref.snr=ref.snr.flag, dapi.snr=dapi.snr.flag, rep=rep.flag,
unique=unique.flag) 
flag.list2$spatial$args <- alist(var="ScaledLogRatio", by.var=NULL,
nk=5, prop=0.25, thr=0.15, beta=1, family="symmetric") 
flag.list2$spot$args <- alist(var="SpotFlag")
flag.list2$spot$char <- "O"
flag.list2$spot$label <- "Image analysis"

## Not run: 
##D edge.norm <- norm.arrayCGH(edge, flag.list=flag.list2,
##D var="LogRatio", FUN=median, na.rm=TRUE)
## End(Not run) 
print(edge.norm$flags) ## spot-level flag summary (computed by flag.summary)



