### Name: CollectionType
### Title: Collection Type Class Constructors
### Aliases: CollectionType NullCollection ExpressionSetCollection
###   KEGGCollection OMIMCollection PfamCollection PrositeCollection
###   PMIDCollection ChrCollection ChrlocCollection MapCollection
###   GOCollection BroadCollection
### Keywords: manip

### ** Examples

NullCollection()

## NullCollection when no collection type specified
collectionType(GeneSet())
collectionType(GeneSet(collectionType=GOCollection()))

## fl could be a url
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
gs1 <- getBroadSets(fl)[[1]]
collectionType(gs1) # BroadCollection

## new BroadCollection, with different category
bc <- BroadCollection(category=new("ScalarCharacter","c2"))
## change collectionType of gs2
gs2 <- gs1
collectionType(gs2) <- NullCollection()



