### Name: racExSet-class
### Title: Class "racExSet" for combining RareAlleleCount representations
###   of SNPs, gene expression data, and other phenotype data
### Aliases: racExSet-class racExSet genesym-class genesym chr20GGdem
###   gse2031GG hgfocusSYMMEMO mgu74av2SYMMEMO snpID snpID-class getpsid
###   snps,racExSet-method snpNames,racExSet-method
###   racAssays,racExSet-method oneFit,racExSet-method litsn exclMono
###   oneFit exprs,racExSet-method initialize,racExSet-method litex pdd
###   racAssays snpNames SNPalleles rarebase SNPalleles,racExSet-method
###   rarebase,racExSet-method
###   oneFit,racExSet,genesym,character,function-method
###   oneFit,racExSet,character,character,function-method
###   oneFit,racExSet,list,character,function-method
###   oneFit,racExSet,list,formula,function-method [,racExSet-method
###   [,snpMeta,ANY,ANY,ANY-method [,racExSet,ANY,ANY,ANY-method
###   show,racExSet-method snps5PrimeTo snps3PrimeTo snpsNear
### Keywords: classes

### ** Examples

example(make_racExSet)
dem
snpNames(dem)[1:4]
featureNames(dem)[1:4]
oneFit(dem, genesym("DDR1"), "rs4814683", lm)
ddr1 = list(DDR1=exprs(dem)["1007_s_at",])
oneFit(dem, ddr1, "rs4814683", aov)
data(chr20GGdem)
ddr1 = list(DDR1=exprs(chr20GGdem)["1007_s_at",])
summary(oneFit(chr20GGdem, ddr1, ~rs4814683+factor(rs6060535), lm))
dim(snps(chr20GGdem))
dim(snps(exclMono(chr20GGdem)))



