### Name: plotProfile
### Title: Visualization of aCGH profiles.
### Aliases: plotProfile plotSummary
### Keywords: misc

### ** Examples

  data(Wilting)
  ## First preprocess the data
  raw.data <- preprocess(Wilting, type="dataframe")
  ## Simple global median normalization for samples with 75% tumor cells
  perc.tumor <- rep(0.75, 3)
  normalized.data <- normalize(raw.data, cellularity=perc.tumor)
  ## Segmentation with slightly relaxed significance level to accept change-points.
  ## Note that segmentation can take a long time.
  ## Not run: segmented.data <- segmentData(normalized.data, alpha=0.02)
  ## Call aberrations
  ## Not run: result <- CGHcall(normalized.data, segmented.data)
  ## Create a plot for the first sample and export it to a file
  ## Not run: plotProfile(result, samples=1, export='plot_1.ps')
  ## Create a summary plot including the first and third sample
  ## Not run: plotSummary(result, samples=c(1,3), export='summary_1_3.ps')  



