### Name: dimnames
### Title: Retrieve the Dimension Names of an RGList_CALIB or SpikeList
###   object.
### Aliases: dimnames.RGList_CALIB dimnames.SpikeList
### Keywords: array

### ** Examples


# for RGList_CALIB
R <- G <- matrix(1:8,4,2)
rownames(R) <- rownames(G) <- c("g1","g2","g3","g4")
colnames(R) <- colnames(G) <- c("a1","a2")
RG <- new("RGList_CALIB",list(R=R,G=G))

dimnames(RG)

# for SpikeList
SR <- SG <- matrix(1:8,4,2)
rownames(SR) <- rownames(SG) <- c("s1","s2","s3","s4")
colnames(SR) <- colnames(SG) <- c("a1","a2")
spike <- new("SpikeList",list(R=SR,G=SG))

dimnames(spike)



