### Name: needwunsQS
### Title: quadratic-space, simple gap implementation of Needleman-Wunsch
###   global alignment algorithm
### Aliases: needwunsQS needwunsQS,character,character-method
###   needwunsQS,character,BString-method
###   needwunsQS,BString,character-method needwunsQS,BString,BString-method
###   print.needwunsQS alignScore.needwunsQS alignScore
### Keywords: models methods

### ** Examples

  ## nucleotide alignment
  mat <- matrix(-5L, nrow=4, ncol=4)
  for (i in seq_len(4)) mat[i, i] <- 0L
  rownames(mat) <- colnames(mat) <- DNA_ALPHABET[1:4]
  s1 <- DNAString(paste(sample(DNA_ALPHABET[1:4], 1000, replace=TRUE), collapse=""))
  s2 <- DNAString(paste(sample(DNA_ALPHABET[1:4], 1000, replace=TRUE), collapse=""))
  nw0 <- needwunsQS(s1, s2, mat, gappen=0)
  nw1 <- needwunsQS(s1, s2, mat, gappen=1)
  nw5 <- needwunsQS(s1, s2, mat, gappen=5)

  ## amino acid alignment
  needwunsQS("PAWHEAE", "HEAGAWGHEE", substmat="BLOSUM50")



