### Name: matchPattern
### Title: String searching functions
### Aliases: matchPattern matchPattern,character-method
###   matchPattern,BString-method matchPattern,BStringViews-method
###   countPattern countPattern,character-method
###   countPattern,BString-method countPattern,BStringViews-method mismatch
###   mismatch,BStringViews-method matchDNAPattern
### Keywords: methods

### ** Examples

  ## A simple fuzzy matching example with a short subject
  x <- DNAString("AAGCGCGATATG")
  m1 <- matchPattern("GCNNNAT", x)
  m1
  m2 <- matchPattern("GCNNNAT", x, fixed=FALSE)
  m2
  as.matrix(m2)

  ## With DNA sequence of yeast chromosome number 1
  data(yeastSEQCHR1)
  yeast1 <- DNAString(yeastSEQCHR1)
  PpiI <- "GAACNNNNNCTC" # a restriction enzyme pattern
  match1.PpiI <- matchPattern(PpiI, yeast1, fixed=FALSE)
  match2.PpiI <- matchPattern(PpiI, yeast1, mismatch=1, fixed=FALSE)

  ## With a genome containing isolated Ns
  library(BSgenome.Celegans.UCSC.ce2)
  chrII <- Celegans[["chrII"]]
  alphabetFrequency(chrII)
  matchPattern("N", chrII)
  matchPattern("TGGGTGTCTTT", chrII) # no match
  matchPattern("TGGGTGTCTTT", chrII, fixed=FALSE) # 1 match

  ## Using wildcards ("N") in the pattern on a genome containing N-blocks
  library(BSgenome.Dmelanogaster.FlyBase.r51)
  chrX <- Dmelanogaster[["X"]]
  noN_chrX <- mask(chrX, "N")
  mask(noN_chrX) # See the N-blocks?
  matchPattern("TTTATGNTTGGTA", noN_chrX, fixed=FALSE)
  ## Can also be achieved with
  matchPattern("TTTATGNTTGGTA", chrX, fixed="subject")



