### Name: BStringViews-io
### Title: Input/output of BStringViews objects
### Aliases: read.BStringViews write.BStringViews FASTArecordsToCharacter
###   CharacterToFASTArecords FASTArecordsToBStringViews
###   BStringViewsToFASTArecords
### Keywords: manip

### ** Examples

  file <- system.file("Exfiles", "someORF.fsa", package="Biostrings")
  x <- read.BStringViews(file, "fasta", "DNAString")
  write.BStringViews(x, format="fasta") # writes to the console

  ## Converting 'x'...
  ## ... to a list of FASTA records (as one returned by the "readFASTA" function)
  x1 <- BStringViewsToFASTArecords(x)
  ## ... to a named character vector
  x2 <- FASTArecordsToCharacter(x1) # same as 'as.character(x)'



