### Name: readFASTA
### Title: Functions to read/write FASTA formatted files
### Aliases: readFASTA writeFASTA
### Keywords: manip

### ** Examples

f1 <- system.file("Exfiles/someORF.fsa", package="Biostrings")
ff <- readFASTA(f1, strip.desc=TRUE)
desc <- sapply(ff, function(x) x$desc)
## Keep the "reverse complement" sequences only
ff2 <- ff[grep("reverse complement", desc, fixed=TRUE)]
writeFASTA(ff2, file.path(tempdir(), "someORF2.fsa"))



