### Name: BString-class
### Title: The BString class
### Aliases: class:BString BString-class initialize,BString-method BString
###   show,BString-method length,BString-method nchar,BString-method
###   [,BString-method [<-,BString-method ==,BString,BString-method
###   ==,BString,character-method ==,character,BString-method
###   !=,BString,BString-method !=,BString,character-method
###   !=,character,BString-method as.character,BString-method
###   toString,BString-method alphabet alphabet,BString-method
### Keywords: methods classes

### ** Examples

  b <- BString("I am a BString object")
  b
  length(b)
  b2 <- b[length(b):1]
  as.character(b2)

  ## b[1:length(b)] is equal but not identical to b!
  b == b[1:length(b)]        # TRUE
  identical(b, 1:length(b))  # FALSE
  ## This is because subsetting a BString object with [ makes a copy
  ## of part or all its sequence data. Hence, for the resulting object,
  ## the internal slot containing the memory address of the sequence
  ## data differs from the original. This is enough for identical() to
  ## see the 2 objects as different. See ?subBString for a much more
  ## efficient substring extraction (does NOT copy the sequence data of
  ## the original object).

  b2 == b                    # FALSE
  b2 == as.character(b2)     # TRUE



