### Name: logLik-methods
### Title: Calculate the log likelihood and its gradient for the vsn model
### Aliases: logLik-methods logLik,vsnInput-method plotVsnLogLik


### ** Examples


data("kidney")

v = new("vsnInput", x=exprs(kidney),
  pstart=array(as.numeric(NA), dim=c(1, ncol(kidney), 2)))
 
fit = vsn2(kidney)

p = sapply(exp(seq(-1, 1, length=31)), function(f) fit@par*c(1,1,f,1))

ll = logLik(v, p)

plot(p[3, ], ll[1, ], type="l", xlab=expression(b[1]), ylab=expression(-log(L)), log="x")
abline(v=fit@par[3], col="red")

plotVsnLogLik(v, fit@par, whichp=c(1,3), expand=c(0.01, 1))



