### Name: createGate
### Title: Gating of a FCS object: Making a Gating/Selection index column
###   for subsequent extraction
### Aliases: createGate icreateGate
### Keywords: iplot manip data

### ** Examples


## example of interactive gating

    if (require(rfcdmin)) {
      data.there<-is.element("MC.053",objects())
      if ((sum(data.there) != length(data.there))) {
        ## obtaining the FCS objects from VRC data
        data(MC.053min)
      }
  
      if (interactive()==TRUE) {
        ## icreateGate: The following will prompt the user for
        ## plotting and gating information.

        ## put two plots on one row 
        par(mfrow=c(2,2))

        ## uniscut: univariate single cut
        MC.053.iuniscut<-icreateGate(MC.053, varpos=2,
               gatingrange=250, type="uniscut")
        ## IndexValue.In = 1

        ## bidcut: bivariate double cut
        MC.053.ibidcut<-icreateGate(MC.053.iuniscut,
            prev.gateNum=1,prev.IndexValue.In=1, type="bidcut")
  
        ## biscut: bivariate single cut
        MC.053.ibiscut<-icreateGate(MC.053.ibidcut, type="biscut")
        ## prev.gateNum=2
         
  
        ## bipcut: bivariate polygonal cut
        MC.053.ibipcut<-icreateGate(MC.053.ibiscut, type="bipcut")
        ## prev.gateNum=3

        ## user-chosen gate
        MC.053.iuser<-icreateGate(MC.053)
      
    }
  
      ## example of creating a gate when parameters are known

      ## uniscut: univariate single cut

      MC.053.gated<-createGate(MC.053, varpos=2, type="uniscut",
                             gatingrange=300, comment="Example")

      if (interactive()){
      ## corresponding icreateGate with a plot and no prompts
      MC.053.igated<-icreateGate(MC.053, varpos=2, type="uniscut",
                             gatingrange=300, comment="plot and gate shown",
                             prompt.all.options=FALSE)
      }
      ## bidcut: bivariate double cut

      MC.053.gated1<-createGate(MC.053, varpos=c(1,2), type="bidcut", 
                              gatingrange=c(250, 500, 0,250),
                              comment="Example")
      if (interactive()){
      ## corresponding icreateGate with a plot and no prompts
      MC.053.igated1<-icreateGate(MC.053, varpos=c(1,2), type="bidcut",
                             gatingrange=c(250, 500, 0,250),
                             comment="plot and gate shown",
                             prompt.all.options=FALSE)
      }
      ## biscut: bivariate single cut

      MC.053.gated<-createGate(MC.053, varpos=c(3,4), type="biscut", 
                             gatingrange=c(250, 500),
                             biscut.quadrant="+/-", comment="Example")

      if (interactive()){
      ## corresponding icreateGate with a plot and no prompts
      MC.053.igated<-icreateGate(MC.053, varpos=c(1,2), type="biscut",
                             gatingrange=c(250, 500),
                             biscut.quadrant="+/-",
                             comment="plot and gate shown",
                             prompt.all.options=FALSE)
      }
      ## bipcut: bivariate polygonal cut

      x.coord<-c(200, 200, 600, 600, 200)
      y.coord<-c(200, 600, 600, 200, 200)
      MC.053.gated2<-createGate(MC.053, varpos=1:2, type="bipcut", 
                              gatingrange=cbind(x.coord, y.coord),
                              comment="Example")
      if (interactive()){
      ## corresponding icreateGate with a plot and no prompts
      MC.053.igated2<-icreateGate(MC.053, varpos=c(1,2), type="bipcut",
                             gatingrange=c(x.coord, y.coord),
                             comment="plot and gate shown",
                             prompt.all.options=FALSE)
      }
    }



