### Name: spotMerge
### Title: Averaging of spot replicas
### Aliases: spotMerge
### Keywords: utilities

### ** Examples


    intensities <- array(data=runif(600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    spotAttr <- data.frame(Name=I(c("y","x","k","l","z")[gl(5,20)]),
                           Zahl=rep(c(1,2,3,4,5),20),
                           Index=c(1:100))
    arrayDataObject <- new("arrayData", intensities=intensities, weights=intensities[,1,],
                           spotAttr=spotAttr, hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprMatrix <- matrix(data=1:600,nrow=100,ncol=6,byrow=FALSE)
    pD <- data.frame(matrix(0,nrow=6,ncol=1))
    exprSetRGObject <- new("exprSetRG", exprs=exprMatrix, se.expr=exprMatrix,
                              phenoData=new("phenoData",
                                pData= pD,varLabels=list(rep("varLabel1",1))),
                              channels=channels)
    resultList <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, identifiersToBeSkipped=c("x","z"))
    resultExprSetRG <- resultList[["exprSetRGObject"]]
    resultY <- (0:5)*100 + sum(1:20)/20
    stopifnot( all( all(exprs(resultExprSetRG)["y",] == resultY) ) )
    resultK <- (0:5)*100 + sum(41:60)/20
    stopifnot( all( all(exprs(resultExprSetRG)["k",] == resultK) ) )
    resultL <- (0:5)*100 + sum(61:80)/20
    stopifnot( all( all(exprs(resultExprSetRG)["l",] == resultL) ) )
    stopifnot( dim(exprs(resultExprSetRG))[1] == 3 )
    stopifnot( dim(exprs(resultExprSetRG))[2] == 6 )
    resultArrayData <- resultList[["arrayDataObject"]]
    stopifnot( all(getIntensities(resultArrayData)[,1,] == getWeights(resultArrayData)) )
    nameColumns <- grep("Name", colnames(getSpotAttr(resultArrayData)))
    zahlColumns <- grep("Zahl", colnames(getSpotAttr(resultArrayData)))
    indexColumns <- grep("Index", colnames(getSpotAttr(resultArrayData)))
    stopifnot( all(getSpotAttr(resultArrayData)["y",nameColumns] == rep ("y", 20 ) ))
    stopifnot( all(getSpotAttr(resultArrayData)["y",indexColumns] == 1:20 ) )
    stopifnot( all(getSpotAttr(resultArrayData)["y",zahlColumns] == rep (1:5, 4 ) ))

 ## Don't show: 
    stopifnot( all(getSpotAttr(resultArrayData)["k",nameColumns] == rep ("k", 20 ) ))
    stopifnot( all(getSpotAttr(resultArrayData)["k",zahlColumns] == rep (1:5, 4) ) )
    stopifnot( all(getSpotAttr(resultArrayData)["l",nameColumns] == rep ("l", 20 ) ))

    se.exprs(exprSetRGObject) <- matrix(nrow=0,ncol=0)
    resultList <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, identifiersToBeSkipped=c("x","z"))
    stopifnot( all( all(exprs(resultExprSetRG)["y",] == resultY) ) )
    stopifnot( all( all(exprs(resultExprSetRG)["k",] == resultK) ) )
    stopifnot( all( all(exprs(resultExprSetRG)["l",] == resultL) ) )

    intensities <- array(data=rep(2,600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","k","l","z"),20))), hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprSetRGObject <- new("exprSetRG", exprs=matrix(data=rep(c(1,2,3,4,5),120),nrow=100,ncol=6,byrow=FALSE), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
    resultList2 <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, identifiersToBeSkipped=c("x","z"))
    resultES <- resultList2[["exprSetRGObject"]]
    resultAD <- resultList2[["arrayDataObject"]]
    stopifnot( dim(exprs(resultES))[1] == 3 )
    stopifnot( dim(exprs(resultES))[2] == 6 )
    stopifnot( all( exprs(resultES)["y",] == 2 ) )
    stopifnot( all( exprs(resultES)["k",] == 3 ) )
    stopifnot( all( exprs(resultES)["l",] == 4 ) )
    stopifnot((all(se.exprs(resultES) == 0)))
    stopifnot( all(getIntensities(resultAD)[,,] == 2) )

    intensities <- array(data=rep(3,600),dim=c(100,2,3))
    dimnames(intensities) <- list(NULL, c("green","red"), NULL)
    arrayDataObject <- new("arrayData", intensities=intensities, spotAttr=data.frame(Name=I(rep(c("x","y","k","l","z"),20))), hybAttrList=NULL)
    indGreen=1:3
    indRed=4:6
    channels <- matrix( c(indGreen,indRed), nrow=length(indGreen), byrow=FALSE )
    colnames(channels) <- c("green","red")
    exprSetRGObject <- new("exprSetRG", exprs=matrix(data=rep(c(1,2,3,4,5,5,4,3,2,1),60),nrow=100,ncol=6,byrow=FALSE), phenoData=new("phenoData", pData=data.frame(matrix(0,nrow=6,ncol=1)), varLabels=list(rep("varLabel1",1))), channels=channels)
    resultList2 <- spotMerge(arrayDataObject=arrayDataObject,exprSetRGObject=exprSetRGObject, identifiersToBeSkipped=c("x","z"))
    resultES <- resultList2[["exprSetRGObject"]]
    resultAD <- resultList2[["arrayDataObject"]]
    stopifnot( dim(exprs(resultES))[1] == 3 )
    stopifnot( dim(exprs(resultES))[2] == 6 )
    stopifnot( all( exprs(resultES)["y",] == 3 ) )
    stopifnot( all( exprs(resultES)["k",] == 3 ) )
    stopifnot( all( exprs(resultES)["l",] == 3 ) )
    stopifnot(all(exprs(resultES) == 3))
    stopifnot( all(getIntensities(resultAD)[,,] == 3) )
    stopifnot( all.equal.numeric( as.vector(se.exprs(resultES)["y",]), as.vector(rep(sd(rep(c(2,4),10)),6) )) )
    stopifnot( all( se.exprs(resultES)["k",] ==  sd(rep(c(3,3),10)) ) )
    stopifnot( all.equal.numeric( as.vector(se.exprs(resultES)["l",]), as.vector(rep(sd(rep(c(4,2),10)),6)) ) )

   ## End Don't show
    

        


