### Name: convertCdf
### Title: Converts a CDF into the same CDF but with another format
### Aliases: convertCdf
### Keywords: file IO

### ** Examples

for (zzz in 0) {

# Find the small 'Test3' CDF file
cdfFile <- findCdf("Test3")
# Find any CDF file
if (is.null(cdfFile))
  cdfFile <- findCdf()
if (is.null(cdfFile))
  break

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Create an identical CDF structure
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
cdfHeader <- readCdfHeader(cdfFile)
outFile <- sprintf("%s-copy.cdf", cdfHeader$chiptype)
convertCdf(cdfFile, outFile, overwrite=TRUE, verbose=TRUE)

# Clean up
rm(cdfFile, cdfHeader)

} # for (zzz in 0)



