### Name: preprocess
### Title: Preprocess Nimblegen Raw Intensities
### Aliases: preprocess
### Keywords: manip

### ** Examples

   exDir <- system.file("exData",package="Ringo")
   exRG <- readNimblegen("example_files.txt","spottypes.txt",path=exDir)
   exampleX <- preprocess(exRG)
   sampleNames(exampleX) <- paste(exRG$targets$Cell.line,
                       exRG$targets$Cy5,exRG$targets$Set,sep=".")
   print(exampleX)

   ### compare VSN to NimbleGen's tukey-biweight normalization
   exampleX.NG <- preprocess(exRG, method="nimblegen")
   sampleNames(exampleX.NG) <- sampleNames(exampleX)
   if (interactive())
     corPlot(cbind(exprs(exampleX),exprs(exampleX.NG)),
       grouping=rep(c("VSN normalized","NimbleGen normalized"),each=2))



