### Name: findPeaksOnSmoothed
### Title: Find peaks on smoothed ExpressionSet
### Aliases: findPeaksOnSmoothed
### Keywords: manip

### ** Examples

  exDir <- system.file("exData",package="Ringo")
  load(file.path(exDir,"exampleProbeAnno.rda"))
  load(file.path(exDir,"exampleX.rda"))
  smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
     modColumn = "Cy5", allChr = c("8"), winHalfSize = 400, combineReplicates=TRUE)
  peaksX <- findPeaksOnSmoothed(smoothX, probeAnno=exProbeAnno,
thresholds=1.5, allChr = c("8"),distCutOff=600, cellType="HL1")
  if (interactive())
    plot(peaksX[[2]], smoothX, probeAnno=exProbeAnno, gff=exGFF)
  peaksX <- relatePeaks(peaksX, exGFF)
  as.data.frame.peakList(peaksX)



