### Name: search.compounds.by.name
### Title: Client-side interface to obtain a list of chemical compounds
### Aliases: search.compounds.by.name search.compounds.by.mass
###   search.compounds.by.composition search.compounds.by.subcomp
### Keywords: datasets

### ** Examples

    if(require("SSOAP") && require("XML")){
        compounds_1 <- search.compounds.by.name("shikimic acid")
        compounds_2 <- search.compounds.by.composition("C7H10O5")
        compounds_3 <- search.compounds.by.mass(174.05, 0.1)
        mol <- bget("-f m cpd:C00111")
        compounds_4 <- search.compounds.by.subcomp(mol, 1, 5)
    }



