### Name: sort.Pedigree
### Title: Sort pedigree
### Aliases: sort.Pedigree
### Keywords: misc

### ** Examples

  ped <- generatePedigree(nId=5)
  ped <- ped[sample(1:nrow(ped)), ]
  sort(ped)
  ## sort(ped, by="dtBirth")       ## TODO
  sort(ped, by="generation")
  ## try(sort(ped, by="pedigree")) ## TODO

  ## Sorting with decreasing generation values from ascendants to descendants
  ped1 <- generatePedigree(nId=5, generationOrder="decreasing")
  sort(ped1, by="generation")
  sort(ped1, decreasing=TRUE, by="generation")
  sort(ped1, decreasing=FALSE, by="generation")

  ## Sorting with unknown values
  ped[1, "generation"] <- NA
  sort(ped, na.last=TRUE, by="generation")
  sort(ped, na.last=FALSE, by="generation")
  sort(ped, na.last=NA, by="generation")



